// dllmain.cpp : Defines the entry point for the DLL application.
#include "stdafx.h"

//uchwyt do biezacej biblioteki DLL
HMODULE uchwytDLL = NULL;

BOOL APIENTRY DllMain( HMODULE hModule,
                       DWORD  ul_reason_for_call,
                       LPVOID lpReserved
					 )
{
	switch (ul_reason_for_call)
	{		
		case DLL_PROCESS_ATTACH:
			uchwytDLL = hModule;
			break;
		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
		case DLL_PROCESS_DETACH:
			break;
	}
	return TRUE;
}

//deklaracja procedury haka
extern "C" __declspec(dllexport) LRESULT CALLBACK KeyboardHookProc(int code,WPARAM wParam,LPARAM lParam);

//uchwyt do haka
HHOOK uchwytHaka = NULL;

//funkcja zakladajaca hak
extern "C" __declspec(dllexport) void __stdcall UstawHak(void)
{
    uchwytHaka = SetWindowsHookEx(WH_KEYBOARD,(HOOKPROC)KeyboardHookProc,uchwytDLL,NULL);
    if (uchwytHaka == NULL) MessageBox(NULL, L"Zaoenie haka nie powiodo si", L"KeyHook",MB_OK | MB_ICONERROR);
    else MessageBox(NULL, L"Zaoenie haka udao si", L"KeyHook", MB_OK | MB_ICONINFORMATION);
}

//funkcja usuwajaca hak
extern "C" __declspec(dllexport) void __stdcall UsunHak(void)
{
	if (UnhookWindowsHookEx(uchwytHaka)) MessageBox(NULL, L"Usunicie haka udao si", L"KeyHook", MB_OK | MB_ICONINFORMATION);
	else MessageBox(NULL, L"Usunicie haka nie powiodo si", L"KeyHook", MB_OK | MB_ICONERROR);
}

//pobrzekujaca procedura haka
LRESULT CALLBACK KeyboardHookProc(int code,WPARAM wParam,LPARAM lParam)
{
    if (code>=HC_ACTION)
    {
        if((lParam & 0x80000000)==0) Beep(150,50);
        else Beep(50,50);
    }
    return CallNextHookEx(uchwytHaka,code,wParam,lParam);
}
